/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.RepoHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javafx.concurrent.Task;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;

public class ConflictingFileWatcher {
    private static ArrayList<String> conflictingThenModifiedFiles = new ArrayList();
    private static ArrayList<String> conflictingFiles = new ArrayList();
    private static final long CONFLICT_CHECK_INTERVAL = 1000L;

    public static ArrayList<String> getConflictingThenModifiedFiles() {
        return conflictingThenModifiedFiles;
    }

    public static void removeFile(String fileToRemove) {
        conflictingThenModifiedFiles.remove(fileToRemove);
    }

    public static void watchConflictingFiles(final RepoHelper currentRepo) throws GitAPIException, IOException {
        if (currentRepo == null) {
            return;
        }
        Thread watcherThread = new Thread((Runnable)new Task<Void>(){

            protected Void call() throws IOException, GitAPIException {
                Set newConflictingFiles = new Git(currentRepo.getRepo()).status().call().getConflicting();
                for (String newFile : newConflictingFiles) {
                    if (conflictingFiles.contains(newFile)) continue;
                    conflictingFiles.add(newFile);
                }
                for (String marked : conflictingThenModifiedFiles) {
                    if (conflictingFiles.contains(marked)) continue;
                    conflictingThenModifiedFiles.remove(marked);
                }
                Path directory = new File(currentRepo.getRepo().getDirectory().getParent()).toPath();
                for (String fileToWatch : conflictingFiles) {
                    Path fileToWatchPath = directory.resolve(new File(fileToWatch).toPath()).getParent();
                    this.watch(fileToWatchPath, fileToWatch);
                }
                return null;
            }

            private void watch(final Path directoryToWatch, final String fileToWatch) throws IOException {
                Thread watch = new Thread((Runnable)new Task<Void>(){

                    protected Void call() throws IOException {
                        WatchService watcher = FileSystems.getDefault().newWatchService();
                        WatchKey key = directoryToWatch.register(watcher, StandardWatchEventKinds.ENTRY_MODIFY);
                        while (conflictingFiles.contains(fileToWatch)) {
                            List<WatchEvent<?>> events = key.pollEvents();
                            for (WatchEvent<?> event : events) {
                                String path = event.context().toString();
                                Path tmp = new File(fileToWatch).toPath();
                                if (!tmp.endsWith(path) && !tmp.toString().equals(path)) continue;
                                conflictingFiles.remove(tmp.toString());
                                conflictingThenModifiedFiles.add(tmp.toString());
                            }
                            boolean valid = key.reset();
                            if (!valid) break;
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        return null;
                    }
                });
                watch.setDaemon(true);
                watch.setName("watching a directory");
                watch.setPriority(2);
                watch.start();
            }
        });
        watcherThread.setDaemon(true);
        watcherThread.setName("initializing a watcher");
        watcherThread.start();
    }
}

