/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.CommitHelper;
import elegit.CommitTreeController;
import elegit.treefx.TreeGraph;
import elegit.treefx.TreeLayout;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Region;

public class CommitTreePanelView
extends Region {
    public boolean isLayoutThreadRunning = false;
    private Task task;
    private Thread th;
    private String name;

    public CommitTreePanelView() {
        this.setMinHeight(0.0);
    }

    private void initCommitTreeScrollPanes(TreeGraph treeGraph) {
        ScrollPane sp = treeGraph.getScrollPane();
        sp.setOnMouseClicked(event -> CommitTreeController.handleMouseClicked());
        this.getChildren().clear();
        this.getChildren().add((Object)this.anchorScrollPane(sp));
        this.isLayoutThreadRunning = false;
    }

    public synchronized void displayTreeGraph(TreeGraph treeGraph, final CommitHelper commitToFocusOnLoad) {
        if (Platform.isFxApplicationThread()) {
            this.initCommitTreeScrollPanes(treeGraph);
        } else {
            Platform.runLater(() -> this.initCommitTreeScrollPanes(treeGraph));
        }
        if (this.isLayoutThreadRunning) {
            this.task.cancel();
            try {
                this.th.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.task = TreeLayout.getTreeLayoutTask(treeGraph);
        this.th = new Thread((Runnable)this.task);
        this.th.setName("Graph Layout: " + this.name);
        this.th.setDaemon(true);
        this.th.start();
        this.isLayoutThreadRunning = true;
        Task<Void> endTask = new Task<Void>(){

            protected Void call() {
                try {
                    CommitTreePanelView.this.th.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    CommitTreePanelView.this.isLayoutThreadRunning = false;
                }
                Platform.runLater(() -> CommitTreeController.focusCommitInGraph(commitToFocusOnLoad));
                return null;
            }
        };
        Thread endThread = new Thread((Runnable)endTask);
        endThread.setName("Layout finalization");
        endThread.setDaemon(true);
        endThread.start();
    }

    public void displayEmptyView() {
        Platform.runLater(() -> {
            ScrollPane sp = new ScrollPane();
            this.getChildren().clear();
            this.getChildren().add((Object)this.anchorScrollPane(sp));
        });
    }

    private ScrollPane anchorScrollPane(ScrollPane sp) {
        sp.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        sp.prefHeightProperty().bind((ObservableValue)this.heightProperty());
        return sp;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

