/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.BranchHelper;
import elegit.CommitHelper;
import elegit.CommitTreeController;
import elegit.CommitTreePanelView;
import elegit.PopUpWindows;
import elegit.RefHelper;
import elegit.RemoteBranchHelper;
import elegit.RepoHelper;
import elegit.SessionModel;
import elegit.TagHelper;
import elegit.UpdateModel;
import elegit.exceptions.MissingRepoException;
import elegit.treefx.Cell;
import elegit.treefx.CellShape;
import elegit.treefx.TreeGraph;
import elegit.treefx.TreeGraphModel;
import elegit.treefx.TreeLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;

public abstract class CommitTreeModel {
    CommitTreePanelView view;
    SessionModel sessionModel;
    TreeGraph treeGraph;
    private List<CommitHelper> commitsInModel;
    private List<CommitHelper> localCommitsInModel;
    private List<CommitHelper> remoteCommitsInModel;
    private List<BranchHelper> branchesInModel;
    private List<TagHelper> tagsInModel;
    public List<TagHelper> tagsToBePushed;
    static final Logger logger = LogManager.getLogger();

    public CommitTreeModel(SessionModel model, CommitTreePanelView view) {
        this.sessionModel = model;
        this.view = view;
        this.view.setName("Generic commit tree");
        CommitTreeController.allCommitTreeModels.add(this);
        this.commitsInModel = new ArrayList<CommitHelper>();
        this.localCommitsInModel = new ArrayList<CommitHelper>();
        this.remoteCommitsInModel = new ArrayList<CommitHelper>();
        this.branchesInModel = new ArrayList<BranchHelper>();
    }

    protected abstract List<BranchHelper> getAllBranches(RepoHelper var1);

    protected abstract List<CommitHelper> getAllCommits(RepoHelper var1);

    public boolean containsID(String id) {
        return this.treeGraph != null && this.treeGraph.treeGraphModel.containsID(id);
    }

    public synchronized void init() {
        this.treeGraph = this.createNewTreeGraph();
        CommitTreeController.resetSelection();
        if (this.sessionModel.getCurrentRepoHelper() != null) {
            this.addAllCommitsToTree();
            this.branchesInModel = this.sessionModel.getCurrentRepoHelper().getBranchModel().getAllBranches();
        }
        this.initView();
    }

    public synchronized void update() throws GitAPIException, IOException {
        if (this.sessionModel.getCurrentRepoHelper() != null) {
            this.sessionModel.getCurrentRepoHelper().updateModel();
            UpdateModel updates = this.getChanges();
            if (!updates.hasChanges()) {
                return;
            }
            this.removeCommitsFromTree(updates.getCommitsToRemove());
            this.addCommitsToTree(updates.getCommitsToAdd());
            this.updateCommitFills(updates.getCommitsToUpdate());
            this.sessionModel.getCurrentRepoHelper().getBranchModel().updateAllBranches();
            this.resetBranchHeads();
            this.updateAllRefLabels();
            TreeLayout.stopMovingCells();
            this.updateView();
        }
    }

    public UpdateModel getChanges() throws IOException {
        UpdateModel updateModel = new UpdateModel();
        RepoHelper repo = this.sessionModel.getCurrentRepoHelper();
        ArrayList<CommitHelper> commitsToAdd = new ArrayList<CommitHelper>(this.getAllCommits(this.sessionModel.getCurrentRepoHelper()));
        commitsToAdd.removeAll(this.getCommitsInModel());
        updateModel.setCommitsToAdd(commitsToAdd);
        ArrayList<CommitHelper> commitsToRemove = new ArrayList<CommitHelper>(this.commitsInModel);
        commitsToRemove.removeAll(this.getAllCommits(this.sessionModel.getCurrentRepoHelper()));
        updateModel.setCommitsToRemove(commitsToRemove);
        List<CommitHelper> commitsToUpdate = new ArrayList<CommitHelper>(this.localCommitsInModel);
        commitsToUpdate.removeAll(repo.getLocalCommits());
        updateModel.updateCommits(commitsToUpdate);
        commitsToUpdate = new ArrayList<CommitHelper>(repo.getLocalCommits());
        commitsToUpdate.removeAll(this.localCommitsInModel);
        updateModel.updateCommits(commitsToUpdate);
        commitsToUpdate = new ArrayList<CommitHelper>(this.remoteCommitsInModel);
        commitsToUpdate.removeAll(repo.getRemoteCommits());
        updateModel.updateCommits(commitsToUpdate);
        commitsToUpdate = new ArrayList<CommitHelper>(repo.getRemoteCommits());
        commitsToUpdate.removeAll(this.remoteCommitsInModel);
        updateModel.updateCommits(commitsToUpdate);
        commitsToUpdate = updateModel.getCommitsToUpdate();
        commitsToUpdate.removeAll(commitsToRemove);
        updateModel.setCommitsToUpdate(commitsToUpdate);
        ArrayList<BranchHelper> branchesToUpdate = new ArrayList<BranchHelper>(this.sessionModel.getCurrentRepoHelper().getBranchModel().getAllBranches());
        HashMap<String, BranchHelper> currentBranchMap = new HashMap<String, BranchHelper>();
        HashMap<String, BranchHelper> updateBranchMap = new HashMap<String, BranchHelper>();
        for (BranchHelper branch : this.branchesInModel) {
            currentBranchMap.put(branch.getRefName(), branch);
        }
        for (BranchHelper branch : branchesToUpdate) {
            updateBranchMap.put(branch.getRefName(), branch);
        }
        for (BranchHelper branch : branchesToUpdate) {
            if (currentBranchMap.containsKey(branch.getRefName()) && ((BranchHelper)currentBranchMap.get(branch.getRefName())).getCommit().getId().equals(branch.getHeadId().getName())) continue;
            updateModel.addBranch(branch);
        }
        for (BranchHelper branch : this.branchesInModel) {
            if (updateBranchMap.containsKey(branch.getRefName())) continue;
            updateModel.addBranch(branch);
        }
        ArrayList<TagHelper> tagsInRepo = new ArrayList<TagHelper>(this.sessionModel.getCurrentRepoHelper().getTagModel().getAllTags());
        for (TagHelper tag : tagsInRepo) {
            if (this.tagsInModel.contains(tag)) continue;
            updateModel.addTag(tag);
        }
        for (TagHelper tag : this.tagsInModel) {
            if (tagsInRepo.contains(tag)) continue;
            updateModel.addTag(tag);
        }
        return updateModel;
    }

    private boolean addAllCommitsToTree() {
        return this.addCommitsToTree(this.getAllCommits(this.sessionModel.getCurrentRepoHelper()));
    }

    private TreeGraph createNewTreeGraph() {
        TreeGraphModel graphModel = new TreeGraphModel();
        this.treeGraph = new TreeGraph(graphModel);
        return this.treeGraph;
    }

    private boolean addCommitsToTree(List<CommitHelper> commits) {
        if (commits.size() == 0) {
            return false;
        }
        for (CommitHelper curCommitHelper : commits) {
            List<CommitHelper> parents = curCommitHelper.getParents();
            this.addCommitToTree(curCommitHelper, parents, this.treeGraph.treeGraphModel);
        }
        return true;
    }

    private boolean removeCommitsFromTree(List<CommitHelper> commits) {
        if (commits.size() == 0) {
            return false;
        }
        for (CommitHelper curCommitHelper : commits) {
            this.removeCommitFromTree(curCommitHelper, this.treeGraph.treeGraphModel);
        }
        return true;
    }

    private boolean updateCommitFills(List<CommitHelper> commits) {
        if (commits.size() == 0) {
            return false;
        }
        for (CommitHelper curCommitHelper : commits) {
            this.updateCommitFill(curCommitHelper, this.treeGraph.treeGraphModel, this.sessionModel.getCurrentRepoHelper());
        }
        return true;
    }

    private void addCommitToTree(CommitHelper commitHelper, List<CommitHelper> parents, TreeGraphModel graphModel) {
        ArrayList<String> parentIds = new ArrayList<String>(parents.size());
        RepoHelper repo = this.sessionModel.getCurrentRepoHelper();
        String displayLabel = repo.getCommitDescriptorString(commitHelper, false);
        List<String> branchLabels = repo.getBranchModel().getBranchesWithHead(commitHelper);
        List<RefHelper> refLabels = repo.getRefsForCommit(commitHelper);
        Cell.CellType computedType = repo.getCommitType(commitHelper);
        this.commitsInModel.add(commitHelper);
        if (computedType == Cell.CellType.BOTH || computedType == Cell.CellType.LOCAL) {
            this.localCommitsInModel.add(commitHelper);
        }
        if (computedType == Cell.CellType.BOTH || computedType == Cell.CellType.REMOTE) {
            this.remoteCommitsInModel.add(commitHelper);
        }
        for (CommitHelper parent : parents) {
            if (!graphModel.containsID(RepoHelper.getCommitId(parent))) {
                this.addCommitToTree(parent, parent.getParents(), graphModel);
            }
            parentIds.add(RepoHelper.getCommitId(parent));
        }
        String commitID = RepoHelper.getCommitId(commitHelper);
        if (graphModel.containsID(commitID)) {
            graphModel.setCellType(commitID, computedType);
            return;
        }
        graphModel.addCell(commitID, commitHelper.getWhen().getTime(), displayLabel, refLabels, this.getContextMenu(commitHelper), parentIds, computedType);
    }

    private void removeCommitFromTree(CommitHelper commitHelper, TreeGraphModel graphModel) {
        String commitID = RepoHelper.getCommitId(commitHelper);
        this.commitsInModel.remove(commitHelper);
        this.localCommitsInModel.remove(commitHelper);
        this.remoteCommitsInModel.remove(commitHelper);
        graphModel.removeCell(commitID);
    }

    private void updateCommitFill(CommitHelper helper, TreeGraphModel graphModel, RepoHelper repo) {
        Cell.CellType type = repo.getLocalCommits().contains(helper) ? (repo.getRemoteCommits().contains(helper) ? Cell.CellType.BOTH : Cell.CellType.LOCAL) : Cell.CellType.REMOTE;
        this.localCommitsInModel.remove(helper);
        this.remoteCommitsInModel.remove(helper);
        switch (type) {
            case LOCAL: {
                this.localCommitsInModel.add(helper);
                break;
            }
            case REMOTE: {
                this.remoteCommitsInModel.add(helper);
                break;
            }
            case BOTH: {
                this.localCommitsInModel.add(helper);
                this.remoteCommitsInModel.add(helper);
                break;
            }
        }
        graphModel.setCellType(helper.getId(), type);
    }

    public ContextMenu getTagLabelMenu(TagHelper tagHelper) {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem deleteitem = new MenuItem("Delete");
        deleteitem.setOnAction(event -> {
            logger.info("Delete tag dialog started.");
            if (tagHelper.presentDeleteDialog()) {
                try {
                    this.sessionModel.getCurrentRepoHelper().getTagModel().deleteTag(tagHelper.getRefName());
                    this.update();
                }
                catch (MissingRepoException | IOException | GitAPIException e) {
                    e.printStackTrace();
                }
            }
        });
        contextMenu.getItems().addAll((Object[])new MenuItem[]{deleteitem});
        return contextMenu;
    }

    private ContextMenu getBranchLabelMenu(BranchHelper branch) {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem checkoutItem = new MenuItem("Checkout");
        checkoutItem.setOnAction(event -> CommitTreeController.sessionController.checkoutBranch(branch));
        MenuItem deleteitem = new MenuItem("Delete");
        deleteitem.setOnAction(event -> CommitTreeController.sessionController.deleteBranch(branch));
        contextMenu.getItems().addAll((Object[])new MenuItem[]{checkoutItem, deleteitem});
        return contextMenu;
    }

    private ContextMenu getContextMenu(CommitHelper commit) {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem checkoutItem = new MenuItem("Checkout files...");
        checkoutItem.setOnAction(event -> {
            logger.info("Checkout files from commit button clicked");
            CommitTreeController.sessionController.handleCheckoutFilesButton(commit);
        });
        Menu relativesMenu = this.getRelativesMenu(commit);
        Menu revertMenu = this.getRevertMenu(commit);
        Menu resetMenu = this.getResetMenu(commit);
        contextMenu.getItems().addAll((Object[])new MenuItem[]{revertMenu, resetMenu, checkoutItem, new SeparatorMenuItem(), relativesMenu});
        return contextMenu;
    }

    private Menu getRelativesMenu(CommitHelper commit) {
        Menu relativesMenu = new Menu("Show Relatives");
        MenuItem parentsItem = new MenuItem("Parents");
        parentsItem.setOnAction(event -> {
            logger.info("Selected see parents");
            CommitTreeController.selectCommit(commit.getId(), true, false, false);
        });
        MenuItem childrenItem = new MenuItem("Children");
        childrenItem.setOnAction(event -> {
            logger.info("Selected see children");
            CommitTreeController.selectCommit(commit.getId(), false, true, false);
        });
        MenuItem parentsAndChildrenItem = new MenuItem("Both");
        parentsAndChildrenItem.setOnAction(event -> {
            logger.info("Selected see children and parents");
            CommitTreeController.selectCommit(commit.getId(), true, true, false);
        });
        relativesMenu.getItems().setAll((Object[])new MenuItem[]{parentsItem, childrenItem, parentsAndChildrenItem});
        return relativesMenu;
    }

    private Menu getRevertMenu(CommitHelper commit) {
        Menu revertMenu = new Menu("Revert...");
        MenuItem revertItem = new MenuItem("Revert this commit");
        MenuItem revertMultipleItem = new MenuItem("Revert multiple commits...");
        revertMultipleItem.disableProperty().bind(CommitTreeController.multipleNotSelectedProperty);
        MenuItem helpItem = new MenuItem("Help");
        revertItem.setOnAction(event -> CommitTreeController.sessionController.handleRevertButton(commit));
        revertMultipleItem.setOnAction(event -> {
            List<CommitHelper> commits = this.commitsInModel.stream().filter(commitHelper -> CommitTreeController.getSelectedIds().contains(commitHelper.getName())).collect(Collectors.toList());
            CommitTreeController.sessionController.handleRevertMultipleButton(commits);
        });
        helpItem.setOnAction(event -> PopUpWindows.showRevertHelpAlert());
        revertMenu.getItems().setAll((Object[])new MenuItem[]{revertItem, revertMultipleItem, helpItem});
        return revertMenu;
    }

    private Menu getResetMenu(CommitHelper commit) {
        Menu resetMenu = new Menu("Reset...");
        MenuItem resetItem = new MenuItem("Reset to this commit");
        MenuItem helpItem = new MenuItem("Help");
        Menu advancedMenu = this.getAdvancedResetMenu(commit);
        resetItem.setOnAction(event -> CommitTreeController.sessionController.handleResetButton(commit));
        helpItem.setOnAction(event -> PopUpWindows.showResetHelpAlert());
        resetMenu.getItems().setAll((Object[])new MenuItem[]{resetItem, advancedMenu, helpItem});
        return resetMenu;
    }

    private Menu getAdvancedResetMenu(CommitHelper commit) {
        Menu resetMenu = new Menu("Advanced");
        MenuItem hardItem = new MenuItem("reset --hard");
        MenuItem mixedItem = new MenuItem("reset --mixed");
        MenuItem softItem = new MenuItem("reset --soft");
        hardItem.setOnAction(event -> CommitTreeController.sessionController.handleAdvancedResetButton(commit, ResetCommand.ResetType.HARD));
        mixedItem.setOnAction(event -> CommitTreeController.sessionController.handleAdvancedResetButton(commit, ResetCommand.ResetType.MIXED));
        softItem.setOnAction(event -> CommitTreeController.sessionController.handleAdvancedResetButton(commit, ResetCommand.ResetType.SOFT));
        resetMenu.getItems().setAll((Object[])new MenuItem[]{hardItem, mixedItem, softItem});
        return resetMenu;
    }

    public void updateView() throws IOException {
        if (this.sessionModel != null && this.sessionModel.getCurrentRepoHelper() != null) {
            CommitTreeController.update(this);
        } else {
            this.view.displayEmptyView();
        }
    }

    private void initView() {
        if (this.sessionModel != null && this.sessionModel.getCurrentRepoHelper() != null) {
            CommitTreeController.init(this);
        } else {
            this.view.displayEmptyView();
        }
    }

    public void setCommitAsBranchHead(CommitHelper helper, boolean tracked) {
        String commitId = "";
        commitId = helper.getId();
        CellShape shape = tracked ? Cell.TRACKED_BRANCH_HEAD_SHAPE : Cell.UNTRACKED_BRANCH_HEAD_SHAPE;
        this.treeGraph.treeGraphModel.setCellShape(commitId, shape);
    }

    public void updateAllRefLabels() {
        RepoHelper repo = this.sessionModel.getCurrentRepoHelper();
        ArrayList<RefHelper> refHelpers = new ArrayList<RefHelper>();
        refHelpers.addAll(repo.getBranchModel().getAllBranches());
        refHelpers.addAll(repo.getTagModel().getAllTags());
        List<RemoteBranchHelper> remotes = repo.getBranchModel().getRemoteBranchesTyped();
        HashMap<RefHelper, ContextMenu> menuMap = new HashMap<RefHelper, ContextMenu>();
        ArrayList<String> remoteBranches = new ArrayList<String>();
        this.tagsInModel = repo.getTagModel().getAllTags();
        HashMap<String, List<RefHelper>> commitLabelMap = new HashMap<String, List<RefHelper>>();
        this.addCommitRefMaps(refHelpers, commitLabelMap, menuMap);
        for (RemoteBranchHelper helper : remotes) {
            remoteBranches.add(helper.getRefName());
        }
        for (String commit : commitLabelMap.keySet()) {
            if (this.sessionModel.getCurrentRepoHelper().getCommit(commit) == null || !this.treeGraph.treeGraphModel.containsID(commit)) continue;
            String displayLabel = repo.getCommitDescriptorString(commit, false);
            this.treeGraph.treeGraphModel.setCellLabels(commit, displayLabel, (List<RefHelper>)((List)commitLabelMap.get(commit)));
            this.treeGraph.treeGraphModel.setCurrentCellLabels(commit, this.sessionModel.getCurrentRepoHelper().getBranchModel().getCurrentAbbrevBranches());
            this.treeGraph.treeGraphModel.setLabelMenus(commit, menuMap);
            this.treeGraph.treeGraphModel.setRemoteBranchCells(commit, remoteBranches);
        }
    }

    private void addCommitRefMaps(List<RefHelper> helpers, Map<String, List<RefHelper>> commitLabelMap, Map<RefHelper, ContextMenu> menuMap) {
        for (RefHelper helper : helpers) {
            String commitId = helper.getCommit().getId();
            if (helper instanceof TagHelper) {
                menuMap.put(helper, this.getTagLabelMenu((TagHelper)helper));
            } else {
                menuMap.put(helper, this.getBranchLabelMenu((BranchHelper)helper));
            }
            if (commitLabelMap.containsKey(commitId)) {
                commitLabelMap.get(commitId).add(helper);
                continue;
            }
            ArrayList<RefHelper> newList = new ArrayList<RefHelper>();
            newList.add(helper);
            commitLabelMap.put(commitId, newList);
        }
    }

    public void resetBranchHeads() {
        List<String> resetIDs = this.treeGraph.treeGraphModel.resetCellShapes();
        RepoHelper repo = this.sessionModel.getCurrentRepoHelper();
        this.branchesInModel = repo.getBranchModel().getAllBranches();
        for (String id : resetIDs) {
            if (this.sessionModel.getCurrentRepoHelper().getCommit(id) == null) continue;
            String displayLabel = repo.getCommitDescriptorString(id, false);
            ArrayList<RefHelper> branchLabels = new ArrayList<RefHelper>();
            this.treeGraph.treeGraphModel.setCellLabels(id, displayLabel, branchLabels);
        }
    }

    public List<TagHelper> getTagsToBePushed() {
        return this.tagsToBePushed;
    }

    public String getViewName() {
        return this.view.getName();
    }

    public List<CommitHelper> getCommitsInModel() {
        return this.commitsInModel;
    }

    public List<BranchHelper> getBranchesInModel() {
        return this.branchesInModel;
    }

    public List<TagHelper> getTagsInModel() {
        return this.tagsInModel;
    }
}

