/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.BranchHelper;
import elegit.CommitHelper;
import elegit.CommitTreeModel;
import elegit.RepoHelper;
import elegit.controllers.SessionController;
import elegit.treefx.Cell;
import elegit.treefx.Highlighter;
import elegit.treefx.TreeGraphModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.eclipse.jgit.api.errors.GitAPIException;

public class CommitTreeController {
    public static List<CommitTreeModel> allCommitTreeModels = new ArrayList<CommitTreeModel>();
    private static List<String> selectedCellIds = new ArrayList<String>();
    public static SessionController sessionController;
    private static ObjectProperty<String> selectedIDProperty;
    static Property<Boolean> multipleNotSelectedProperty;

    public static void handleMouseClicked(String clickedCellId) {
        if (selectedCellIds.size() == 1 && clickedCellId.equals(selectedCellIds.get(0))) {
            CommitTreeController.resetSelection();
        } else if (selectedCellIds.size() == 0) {
            CommitTreeController.selectCommit(clickedCellId, false, false, false);
        } else {
            CommitTreeController.resetSelection();
            CommitTreeController.selectCommit(clickedCellId, false, false, false);
        }
    }

    public static void handleMouseClickedShift(Cell cell) {
        if (selectedCellIds.contains(cell.getCellId())) {
            if (CommitTreeController.isSelected(cell.getCellId())) {
                selectedIDProperty.set(null);
                sessionController.clearSelectedCommit();
            }
            Highlighter.resetCell(cell);
            selectedCellIds.remove(cell.getCellId());
            multipleNotSelectedProperty.setValue((Object)(selectedCellIds.size() < 2 ? 1 : 0));
        } else if (selectedCellIds.size() == 0) {
            CommitTreeController.selectCommit(cell.getCellId(), false, false, false);
        } else {
            CommitTreeController.selectCommitInGraph(cell.getCellId(), false, false, false);
        }
    }

    static List<String> getSelectedIds() {
        return selectedCellIds;
    }

    static void handleMouseClicked() {
        CommitTreeController.resetSelection();
    }

    public static void handleMouseover(Cell cell, boolean isOverCell) {
        CommitTreeController.highlightCommitInGraph(cell.getCellId(), isOverCell);
    }

    private static void selectCommitInGraph(String commitID, boolean ancestors, boolean descendants, boolean allGenerations) {
        for (CommitTreeModel model : allCommitTreeModels) {
            if (model.treeGraph == null) continue;
            TreeGraphModel m = model.treeGraph.treeGraphModel;
            CommitTreeController.selectCommitInGraph(commitID, m, true, ancestors, descendants, allGenerations);
        }
        selectedCellIds.add(commitID);
        selectedIDProperty.set((Object)commitID);
        multipleNotSelectedProperty.setValue((Object)(selectedCellIds.size() < 2 ? 1 : 0));
    }

    private static void highlightCommitInGraph(String commitID, boolean isOverCell) {
        for (CommitTreeModel model : allCommitTreeModels) {
            if (model.treeGraph == null) continue;
            TreeGraphModel m = model.treeGraph.treeGraphModel;
            if (selectedCellIds.size() <= 0 || CommitTreeController.isSelected(commitID)) continue;
            Highlighter.highlightCell(commitID, selectedCellIds.get(0), m, isOverCell);
            Highlighter.updateCellEdges(commitID, selectedCellIds.get(0), m, isOverCell);
        }
    }

    private static void selectCommitInGraph(String commitID, TreeGraphModel model, boolean enable, boolean ancestors, boolean descendants, boolean allGenerations) {
        Highlighter.highlightSelectedCell(commitID, model, enable, ancestors, descendants, allGenerations);
        if (enable) {
            Highlighter.updateCellEdges(commitID, commitID, model, true);
        } else {
            Highlighter.updateCellEdges(commitID, null, model, false);
        }
    }

    public static void selectCommit(String id, boolean ancestors, boolean descendants, boolean allGenerations) {
        CommitTreeController.resetSelection();
        CommitTreeController.selectCommitInGraph(id, ancestors, descendants, allGenerations);
        sessionController.selectCommit(id);
    }

    public static void resetSelection() {
        if (selectedCellIds.size() > 0) {
            Highlighter.resetAll();
            selectedCellIds.clear();
            selectedIDProperty.set(null);
            multipleNotSelectedProperty.setValue((Object)true);
        }
        sessionController.clearSelectedCommit();
    }

    private static boolean isSelected(String cellID) {
        return selectedCellIds.size() == 1 && selectedCellIds.get(0).equals(cellID);
    }

    public static void init(CommitTreeModel commitTreeModel) {
        RepoHelper repo = commitTreeModel.sessionModel.getCurrentRepoHelper();
        commitTreeModel.treeGraph.update();
        CommitTreeController.setBranchHeads(commitTreeModel, repo);
        commitTreeModel.view.displayTreeGraph(commitTreeModel.treeGraph, commitTreeModel.sessionModel.getCurrentRepoHelper().getBranchModel().getCurrentBranchHead());
    }

    public static void update(CommitTreeModel commitTreeModel) {
        RepoHelper repo = commitTreeModel.sessionModel.getCurrentRepoHelper();
        commitTreeModel.treeGraph.update();
        commitTreeModel.view.displayTreeGraph(commitTreeModel.treeGraph, commitTreeModel.sessionModel.getCurrentRepoHelper().getBranchModel().getCurrentBranchHead());
        CommitTreeController.setBranchHeads(commitTreeModel, repo);
    }

    public static void focusCommitInGraph(CommitHelper commit) {
        if (commit == null) {
            return;
        }
        for (CommitTreeModel model : allCommitTreeModels) {
            if (model.treeGraph == null || !model.treeGraph.treeGraphModel.containsID(commit.getId())) continue;
            Cell c = model.treeGraph.treeGraphModel.cellMap.get(commit.getId());
            Highlighter.emphasizeCell(c);
        }
    }

    public static void focusCommitInGraph(String commitID) {
        if (commitID == null) {
            return;
        }
        for (CommitTreeModel model : allCommitTreeModels) {
            if (model.treeGraph == null || !model.treeGraph.treeGraphModel.containsID(commitID)) continue;
            Cell c = model.treeGraph.treeGraphModel.cellMap.get(commitID);
            Highlighter.emphasizeCell(c);
        }
    }

    public static boolean setBranchHeads(CommitTreeModel model, RepoHelper repo) {
        try {
            repo.getBranchModel().updateAllBranches();
        }
        catch (IOException | GitAPIException throwable) {
            // empty catch block
        }
        Map<CommitHelper, List<BranchHelper>> headIds = repo.getBranchModel().getAllBranchHeads();
        if (headIds == null) {
            return false;
        }
        model.resetBranchHeads();
        for (CommitHelper head : headIds.keySet()) {
            boolean isTracked = false;
            for (BranchHelper branch : headIds.get(head)) {
                if (!repo.getBranchModel().isBranchTracked(branch)) continue;
                isTracked = true;
            }
            model.setCommitAsBranchHead(head, isTracked);
        }
        model.updateAllRefLabels();
        return true;
    }

    public static ObjectProperty<String> selectedIDProperty() {
        return selectedIDProperty;
    }

    public static CommitTreeModel getCommitTreeModel() {
        return allCommitTreeModels.get(0);
    }

    static {
        selectedIDProperty = new SimpleObjectProperty();
        multipleNotSelectedProperty = new SimpleBooleanProperty(true);
    }
}

