/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.RepoHelper;
import elegit.TagHelper;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;

public class CommitHelper {
    RevCommit commit;
    PersonIdent author;
    ParentCommitHelper parents;
    List<CommitHelper> children;
    String shortMessage;
    String fullMessage;
    List<TagHelper> tags;

    public CommitHelper(RevCommit c) throws IOException {
        this.commit = c;
        this.author = c.getAuthorIdent();
        this.children = new ArrayList<CommitHelper>();
        this.parents = new ParentCommitHelper(this);
        this.fullMessage = c.getFullMessage();
        this.shortMessage = c.getShortMessage();
    }

    public CommitHelper(ObjectId id, RepoHelper repoHelper) throws IOException {
        this(repoHelper.parseRawCommit(id));
    }

    public CommitHelper(String refString, RepoHelper repoHelper) throws IOException {
        this(repoHelper.getRepo().resolve(refString), repoHelper);
    }

    public String getName() {
        return this.commit.getName();
    }

    public ObjectId getObjectId() {
        return this.commit.getId();
    }

    public String getId() {
        return RepoHelper.getCommitId(this);
    }

    public String getMessage(boolean fullMessage) {
        if (fullMessage) {
            return this.fullMessage;
        }
        return this.shortMessage;
    }

    public String getAuthorName() {
        return this.author.getName();
    }

    public String getAuthorEmail() {
        return this.author.getEmailAddress();
    }

    public Date getWhen() {
        return this.author.getWhen();
    }

    public String getFormattedWhen() {
        SimpleDateFormat formatter = new SimpleDateFormat("MMM dd yyyy, h:mm a");
        return formatter.format(this.getWhen());
    }

    public void addParent(CommitHelper parent) {
        if (this.parents == null) {
            this.parents = new ParentCommitHelper(this, parent);
        } else {
            this.parents.addParent(parent);
        }
    }

    public int getParentCount() {
        return this.parents.count();
    }

    public List<CommitHelper> getParents() {
        return this.parents.toList();
    }

    public boolean isChild(CommitHelper commit, int depth) {
        --depth;
        if (this.children.contains(commit)) {
            return true;
        }
        if (depth != 0) {
            for (CommitHelper child : this.children) {
                if (!child.isChild(commit, depth)) continue;
                return true;
            }
        }
        return false;
    }

    public void addChild(CommitHelper child) {
        if (!this.isChild(child, 1)) {
            this.children.add(child);
        }
    }

    public List<CommitHelper> getChildren() {
        return this.children;
    }

    public String toString() {
        String s = this.getAuthorName();
        s = s + " \t" + this.getFormattedWhen();
        s = s + " \t" + this.getName();
        s = s + " \t" + this.getMessage(false);
        return s;
    }

    public void addTag(TagHelper t) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagHelper>();
        }
        this.tags.add(t);
    }

    public void removeTag(String s) {
        for (TagHelper tag : this.tags) {
            if (!tag.getRefName().equals(s)) continue;
            this.tags.remove(tag);
            return;
        }
    }

    public List<TagHelper> getTags() {
        if (this.tags == null) {
            this.tags = new ArrayList<TagHelper>();
        }
        return this.tags;
    }

    public List<String> getTagNames() {
        if (this.tags == null) {
            this.tags = new ArrayList<TagHelper>();
        }
        ArrayList<String> tagNames = new ArrayList<String>();
        for (TagHelper tag : this.tags) {
            tagNames.add(tag.getRefName());
        }
        return tagNames;
    }

    public boolean hasTags() {
        return this.tags.size() != 0;
    }

    public boolean hasTag(String tagName) {
        return this.getTagNames().contains(tagName);
    }

    public RevCommit getCommit() {
        return this.commit;
    }

    public int hashCode() {
        return this.commit.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof CommitHelper && this.commit.equals((AnyObjectId)((CommitHelper)other).getCommit());
    }

    private class ParentCommitHelper {
        private CommitHelper child;
        private ArrayList<CommitHelper> parents = new ArrayList();

        public ParentCommitHelper(CommitHelper child, CommitHelper parent) {
            this.parents.add(parent);
            this.setChild(child);
        }

        public ParentCommitHelper(CommitHelper child) {
            this.setChild(child);
        }

        public int count() {
            return this.parents.size();
        }

        public List<CommitHelper> toList() {
            return this.parents;
        }

        private void setChild(CommitHelper child) {
            this.child = child;
            for (CommitHelper parent : this.parents) {
                if (parent == null) continue;
                parent.addChild(child);
            }
        }

        public void addParent(CommitHelper parent) {
            if (!this.parents.contains(parent)) {
                parent.addChild(this.child);
                this.parents.add(parent);
            }
        }
    }
}

