/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import com.jcraft.jsch.UserInfo;
import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.GlyphsDude;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import elegit.AuthMethod;
import elegit.ClonedRepoHelper;
import elegit.ElegitUserInfoGUI;
import elegit.RepoHelper;
import elegit.RepoHelperBuilder;
import elegit.SessionModel;
import elegit.exceptions.CancelledAuthorizationException;
import elegit.exceptions.NoRepoSelectedException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogEvent;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;
import javafx.util.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class ClonedRepoHelperBuilder
extends RepoHelperBuilder {
    private static String prevRemoteURL;
    private static String prevDestinationPath;
    private static String prevRepoName;
    static final Logger logger;
    private ButtonType cloneButtonType;
    private TextField remoteURLField;
    private TextField enclosingFolderField;
    private TextField repoNameField;

    public ClonedRepoHelperBuilder(SessionModel sessionModel) {
        super(sessionModel);
    }

    @Override
    public RepoHelper getRepoHelperFromDialogs() throws GitAPIException, IOException, NoRepoSelectedException, CancelledAuthorizationException {
        Dialog<Pair<String, String>> dialog = this.createCloneDialog();
        this.setUpDialogButtons(dialog);
        this.arrangeDialogFields(dialog);
        this.configureCloneButton(dialog);
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            Path destinationPath = Paths.get((String)((Pair)result.get()).getKey(), new String[0]);
            String remoteURL = (String)((Pair)result.get()).getValue();
            RepoHelperBuilder.AuthDialogResponse response = RepoHelperBuilder.getAuthCredentialFromDialog();
            RepoHelper repoHelper = ClonedRepoHelperBuilder.cloneRepositoryWithChecks(remoteURL, destinationPath, response, new ElegitUserInfoGUI());
            return repoHelper;
        }
        logger.info("Cloned repo helper dialog canceled");
        throw new NoRepoSelectedException();
    }

    private Dialog<Pair<String, String>> createCloneDialog() {
        logger.info("Load remote repo dialog started");
        Dialog dialog = new Dialog();
        dialog.setTitle("Clone");
        dialog.setHeaderText("Clone a remote repository");
        return dialog;
    }

    private void setUpDialogButtons(Dialog<Pair<String, String>> dialog) {
        this.cloneButtonType = new ButtonType("Clone", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{this.cloneButtonType, ButtonType.CANCEL});
        Node cloneButton = dialog.getDialogPane().lookupButton(this.cloneButtonType);
        cloneButton.setDisable(true);
        dialog.setOnCloseRequest((EventHandler)new EventHandler<DialogEvent>(){

            public void handle(DialogEvent event) {
                logger.info("Closed clone from remote dialog");
            }
        });
    }

    private void arrangeDialogFields(Dialog<Pair<String, String>> dialog) {
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        Text instructionsText = new Text("Select an enclosing folder for the repository folder\nto be created in.");
        this.remoteURLField = new TextField();
        this.remoteURLField.setPromptText("Remote URL");
        if (prevRemoteURL != null) {
            this.remoteURLField.setText(prevRemoteURL);
        }
        this.enclosingFolderField = new TextField();
        this.enclosingFolderField.setEditable(false);
        if (prevDestinationPath != null) {
            this.enclosingFolderField.setText(prevDestinationPath);
        }
        Text enclosingDirectoryPathText = new Text();
        Button chooseDirectoryButton = new Button();
        Text folderIcon = GlyphsDude.createIcon((GlyphIcons)FontAwesomeIcon.FOLDER_OPEN);
        chooseDirectoryButton.setGraphic((Node)folderIcon);
        chooseDirectoryButton.setOnAction(t -> {
            File cloneRepoDirectory = this.getDirectoryPathFromChooser("Choose clone destination folder", null);
            if (cloneRepoDirectory != null) {
                this.enclosingFolderField.setText(cloneRepoDirectory.toString());
                enclosingDirectoryPathText.setText(cloneRepoDirectory.toString() + File.separator);
            }
        });
        this.repoNameField = new TextField();
        this.repoNameField.setPromptText("Repository name...");
        if (prevRepoName != null) {
            this.repoNameField.setText(prevRepoName);
        }
        int instructionsRow = 0;
        int remoteURLRow = instructionsRow + 1;
        int enclosingFolderRow = remoteURLRow + 1;
        int repositoryNameRow = enclosingFolderRow + 1;
        grid.add((Node)instructionsText, 0, instructionsRow, 2, 1);
        grid.add((Node)new Label("Remote URL:"), 0, remoteURLRow);
        grid.add((Node)this.remoteURLField, 1, remoteURLRow);
        grid.add((Node)new Label("Enclosing folder:"), 0, enclosingFolderRow);
        grid.add((Node)this.enclosingFolderField, 1, enclosingFolderRow);
        grid.add((Node)chooseDirectoryButton, 2, enclosingFolderRow);
        grid.add((Node)new Label("Repository name:"), 0, repositoryNameRow);
        grid.add((Node)this.repoNameField, 1, repositoryNameRow);
        dialog.getDialogPane().setContent((Node)grid);
        Platform.runLater(() -> ((TextField)this.remoteURLField).requestFocus());
    }

    private void configureCloneButton(Dialog<Pair<String, String>> dialog) {
        Node cloneButton = dialog.getDialogPane().lookupButton(this.cloneButtonType);
        SimpleBooleanProperty invalidRepoNameProperty = new SimpleBooleanProperty(this.repoNameField.getText().trim().contains("/") || this.repoNameField.getText().trim().contains("."));
        cloneButton.disableProperty().bind((ObservableValue)this.enclosingFolderField.textProperty().isEmpty().or((ObservableBooleanValue)this.repoNameField.textProperty().isEmpty()).or((ObservableBooleanValue)this.remoteURLField.textProperty().isEmpty()).or((ObservableBooleanValue)invalidRepoNameProperty));
        this.repoNameField.textProperty().addListener((arg_0, arg_1, arg_2) -> ClonedRepoHelperBuilder.lambda$configureCloneButton$1((BooleanProperty)invalidRepoNameProperty, arg_0, arg_1, arg_2));
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == this.cloneButtonType) {
                prevRemoteURL = this.remoteURLField.getText().trim();
                prevDestinationPath = this.enclosingFolderField.getText().trim();
                prevRepoName = this.repoNameField.getText().trim();
                return new Pair((Object)(this.enclosingFolderField.getText().trim() + File.separator + this.repoNameField.getText().trim()), (Object)this.remoteURLField.getText().trim());
            }
            return null;
        });
    }

    static RepoHelper cloneRepositoryWithChecks(String remoteURL, Path destinationPath, RepoHelperBuilder.AuthDialogResponse response, UserInfo userInfo) throws GitAPIException, IOException, CancelledAuthorizationException, NoRepoSelectedException {
        ClonedRepoHelper repoHelper;
        UsernamePasswordCredentialsProvider credentials;
        block5: {
            credentials = new UsernamePasswordCredentialsProvider(response.username, response.password);
            String sshPassword = response.password;
            LsRemoteCommand command = Git.lsRemoteRepository().setRemote(remoteURL);
            repoHelper = new ClonedRepoHelper(destinationPath, remoteURL, sshPassword, userInfo);
            repoHelper.wrapAuthentication((TransportCommand)command, credentials);
            try {
                command.call();
            }
            catch (TransportException e) {
                System.out.println(e.getMessage());
                System.out.println(e.getMessage().endsWith("not authorized") || e.getMessage().endsWith("not authorized."));
                System.out.println(e.getMessage().endsWith("not found") || e.getMessage().endsWith("not found."));
                if (e.getMessage().endsWith("not found") || e.getMessage().endsWith("not found.")) {
                    logger.error("Invalid remote exception thrown");
                    throw new InvalidRemoteException("Caught invalid repository when building a ClonedRepoHelper.");
                }
                if (!e.getMessage().endsWith("not authorized") && !e.getMessage().endsWith("not authorized.")) break block5;
                logger.error("Authentication error");
            }
        }
        if (response.protocol == AuthMethod.SSH) {
            repoHelper.obtainRepository(remoteURL);
        } else {
            repoHelper.setUsernamePasswordCredentials(credentials);
            repoHelper.obtainRepository(remoteURL);
        }
        return repoHelper;
    }

    public String getPrevDestinationPath() {
        return prevDestinationPath;
    }

    public String getPrevRepoName() {
        return prevRepoName;
    }

    private static /* synthetic */ void lambda$configureCloneButton$1(BooleanProperty invalidRepoNameProperty, ObservableValue observable, String oldValue, String newValue) {
        invalidRepoNameProperty.set(newValue.trim().contains("/") || newValue.trim().contains("."));
    }

    static {
        logger = LogManager.getLogger();
    }
}

