/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class BusyWindow {
    private static Stage window = BusyWindow.initWindow();
    private static int numProcessesActive = 0;
    private static Text loadingMessage;

    private static Stage initWindow() {
        window = new Stage();
        window.setMaxHeight(200.0);
        window.setMaxWidth(300.0);
        window.setMinHeight(200.0);
        window.setMinWidth(300.0);
        window.initStyle(StageStyle.UNDECORATED);
        window.initModality(Modality.APPLICATION_MODAL);
        loadingMessage = new Text("loading");
        loadingMessage.setFont(new Font(20.0));
        window.setScene(new Scene(BusyWindow.getRootOfScene()));
        return window;
    }

    private static Parent getRootOfScene() {
        ImageView img = new ImageView(new Image("/elegit/images/loading.gif"));
        VBox parent = new VBox(new Node[]{img, loadingMessage});
        parent.setSpacing(20.0);
        parent.setAlignment(Pos.CENTER);
        return parent;
    }

    public static void setParentWindow(Window parent) {
        window.initOwner(parent);
    }

    public static void show() {
        if (numProcessesActive == 0) {
            Platform.runLater(() -> ((Stage)window).show());
        }
        ++numProcessesActive;
    }

    public static void hide() {
        if (--numProcessesActive == 0) {
            Platform.runLater(() -> {
                window.hide();
                loadingMessage.setText("Loading...");
            });
        }
    }

    public static void setLoadingText(String message) {
        loadingMessage.setText(message);
    }
}

