/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.BranchHelper;
import elegit.CommitHelper;
import elegit.LocalBranchHelper;
import elegit.RefHelper;
import elegit.RemoteBranchHelper;
import elegit.RepoHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.CannotDeleteCurrentBranchException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NotMergedException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BranchTrackingStatus;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;

public class BranchModel {
    private RepoHelper repoHelper;
    private BranchHelper currentBranch;
    private List<LocalBranchHelper> localBranchesTyped;
    private List<RemoteBranchHelper> remoteBranchesTyped;
    static final Logger logger = LogManager.getLogger();

    public BranchModel(RepoHelper repoHelper) throws GitAPIException, IOException {
        this.repoHelper = repoHelper;
        this.updateAllBranches();
    }

    public void updateAllBranches() throws GitAPIException, IOException {
        this.updateLocalBranches();
        this.updateRemoteBranches();
        this.refreshHeadIds();
        this.refreshCurrentBranch();
    }

    public void updateLocalBranches() throws GitAPIException, IOException {
        List getBranchesCall = new Git(this.repoHelper.getRepo()).branchList().call();
        this.localBranchesTyped = new ArrayList<LocalBranchHelper>();
        for (Ref ref : getBranchesCall) {
            this.localBranchesTyped.add(new LocalBranchHelper(ref, this.repoHelper));
        }
    }

    public void updateRemoteBranches() throws GitAPIException, IOException {
        List getBranchesCall = new Git(this.repoHelper.getRepo()).branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
        this.remoteBranchesTyped = new ArrayList<RemoteBranchHelper>();
        for (Ref ref : getBranchesCall) {
            if (ref.getName().equals("HEAD")) continue;
            this.remoteBranchesTyped.add(new RemoteBranchHelper(ref, this.repoHelper));
        }
    }

    public void refreshCurrentBranch() throws IOException {
        String currentBranchRefString = this.repoHelper.getRepo().getFullBranch();
        for (LocalBranchHelper branch : this.localBranchesTyped) {
            if (!branch.getRefPathString().equals(currentBranchRefString)) continue;
            this.currentBranch = branch;
            return;
        }
        this.currentBranch = new LocalBranchHelper(currentBranchRefString, this.repoHelper);
    }

    public void refreshHeadIds() {
        this.refreshHeadIdsType(BranchType.LOCAL);
        this.refreshHeadIdsType(BranchType.REMOTE);
    }

    public void refreshHeadIdsType(BranchType type) {
        List<BranchHelper> listToRefresh = type == BranchType.LOCAL ? this.localBranchesTyped : this.remoteBranchesTyped;
        for (BranchHelper branch : listToRefresh) {
            if (branch.getCommit() != null) continue;
            try {
                branch.getHeadId();
            }
            catch (IOException e) {
                logger.error("IOException getting local branches");
                logger.debug((Object)e.getStackTrace());
                e.printStackTrace();
            }
        }
    }

    public LocalBranchHelper trackRemoteBranch(RemoteBranchHelper remoteBranchHelper) throws GitAPIException, IOException {
        LocalBranchHelper tracker = this.createLocalTrackingBranchForRemote(remoteBranchHelper);
        this.localBranchesTyped.add(tracker);
        return tracker;
    }

    private LocalBranchHelper createLocalTrackingBranchForRemote(RemoteBranchHelper remoteBranchHelper) throws GitAPIException, IOException {
        String localBranchName = this.repoHelper.getRepo().shortenRemoteBranchName(remoteBranchHelper.getRefPathString());
        Ref trackingBranchRef = new Git(this.repoHelper.getRepo()).branchCreate().setName(localBranchName).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint(remoteBranchHelper.getRefPathString()).call();
        LocalBranchHelper newHelper = new LocalBranchHelper(trackingBranchRef, this.repoHelper);
        this.localBranchesTyped.add(newHelper);
        return newHelper;
    }

    public LocalBranchHelper createNewLocalBranch(String branchName) throws GitAPIException, IOException {
        Git git = new Git(this.repoHelper.getRepo());
        Ref newBranch = git.branchCreate().setName(branchName).call();
        LocalBranchHelper newLocalBranchHelper = new LocalBranchHelper(newBranch, this.repoHelper);
        this.localBranchesTyped.add(newLocalBranchHelper);
        git.close();
        return newLocalBranchHelper;
    }

    public void deleteLocalBranch(LocalBranchHelper localBranchToDelete) throws NotMergedException, CannotDeleteCurrentBranchException, GitAPIException {
        Git git = new Git(this.repoHelper.getRepo());
        git.branchDelete().setBranchNames(new String[]{localBranchToDelete.getRefPathString()}).call();
        this.localBranchesTyped.remove(localBranchToDelete);
        git.close();
    }

    public void forceDeleteLocalBranch(LocalBranchHelper branchToDelete) throws CannotDeleteCurrentBranchException, GitAPIException {
        Git git = new Git(this.repoHelper.getRepo());
        git.branchDelete().setForce(true).setBranchNames(new String[]{branchToDelete.getRefPathString()}).call();
        this.localBranchesTyped.remove(branchToDelete);
        git.close();
    }

    public RemoteRefUpdate.Status deleteRemoteBranch(RemoteBranchHelper branchHelper) throws GitAPIException, IOException {
        PushCommand pushCommand = new Git(this.repoHelper.repo).push();
        pushCommand.setRemote("origin").add(":refs/heads/" + branchHelper.parseBranchName());
        this.repoHelper.myWrapAuthentication((TransportCommand)pushCommand);
        this.updateRemoteBranches();
        boolean succeeded = false;
        for (PushResult result : pushCommand.call()) {
            Iterator iterator = result.getRemoteUpdates().iterator();
            if (!iterator.hasNext()) continue;
            RemoteRefUpdate refUpdate = (RemoteRefUpdate)iterator.next();
            return refUpdate.getStatus();
        }
        return null;
    }

    public MergeResult mergeWithBranch(BranchHelper branchToMergeFrom) throws GitAPIException, IOException {
        Git git = new Git(this.repoHelper.getRepo());
        MergeCommand merge = git.merge();
        merge.include((AnyObjectId)this.repoHelper.getRepo().resolve(branchToMergeFrom.getRefPathString()));
        MergeResult mergeResult = merge.call();
        git.close();
        return mergeResult;
    }

    public BranchHelper getCurrentBranch() {
        return this.currentBranch;
    }

    public CommitHelper getCurrentRemoteBranchHead() throws IOException {
        String remoteBranch = this.getCurrentRemoteBranch();
        if (remoteBranch != null) {
            return this.getBranchByName(BranchType.REMOTE, remoteBranch).getCommit();
        }
        return null;
    }

    public String getCurrentRemoteBranch() throws IOException {
        if (BranchTrackingStatus.of((Repository)this.repoHelper.repo, (String)this.currentBranch.getRefName()) != null) {
            return Repository.shortenRefName((String)BranchTrackingStatus.of((Repository)this.repoHelper.repo, (String)this.currentBranch.getRefName()).getRemoteTrackingBranch());
        }
        return null;
    }

    public String getCurrentRemoteAbbrevBranch() throws IOException {
        if (BranchTrackingStatus.of((Repository)this.repoHelper.repo, (String)this.currentBranch.getRefName()) != null) {
            String name = Repository.shortenRefName((String)BranchTrackingStatus.of((Repository)this.repoHelper.repo, (String)this.currentBranch.getRefName()).getRemoteTrackingBranch());
            if (name.length() > 25) {
                name = name.substring(0, 24) + "...";
            }
            return name;
        }
        return null;
    }

    public CommitHelper getCurrentBranchHead() {
        return this.currentBranch == null ? null : this.currentBranch.getCommit();
    }

    public List<? extends BranchHelper> getBranchListTyped(BranchType type) {
        return type == BranchType.LOCAL ? this.localBranchesTyped : this.remoteBranchesTyped;
    }

    public List<LocalBranchHelper> getLocalBranchesTyped() {
        return this.localBranchesTyped;
    }

    public List<RemoteBranchHelper> getRemoteBranchesTyped() {
        return this.remoteBranchesTyped;
    }

    public List<BranchHelper> getBranchListUntyped(BranchType type) {
        List<BranchHelper> typed = type == BranchType.LOCAL ? this.localBranchesTyped : this.remoteBranchesTyped;
        ArrayList<BranchHelper> untyped = new ArrayList<BranchHelper>();
        for (BranchHelper branch : typed) {
            untyped.add(branch);
        }
        return untyped;
    }

    public List<BranchHelper> getAllBranches() {
        ArrayList<BranchHelper> tmp = new ArrayList<BranchHelper>();
        for (BranchHelper branchHelper : this.remoteBranchesTyped) {
            tmp.add(branchHelper);
        }
        for (BranchHelper branchHelper : this.localBranchesTyped) {
            tmp.add(branchHelper);
        }
        return tmp;
    }

    public BranchHelper getBranchByName(BranchType type, String branchName) {
        List<BranchHelper> branchList = type == BranchType.LOCAL ? this.localBranchesTyped : this.remoteBranchesTyped;
        for (BranchHelper branch : branchList) {
            if (!branch.getRefName().equals(branchName)) continue;
            return branch;
        }
        return null;
    }

    public boolean isBranchTracked(BranchHelper branch) {
        String branchName = branch.getRefName();
        if (branch instanceof LocalBranchHelper) {
            String merge = this.repoHelper.getRepo().getConfig().getString("branch", branchName, "merge");
            return merge != null;
        }
        for (BranchHelper branchHelper : this.localBranchesTyped) {
            if (this.repoHelper.getRepo().getConfig().getString("branch", branchHelper.getRefName(), "merge") == null) continue;
            this.repoHelper.getRepo();
            if (!Repository.shortenRefName((String)this.repoHelper.getRepo().getConfig().getString("branch", branchHelper.getRefName(), "merge")).equals(this.repoHelper.getRepo().shortenRemoteBranchName(branch.getRefPathString()))) continue;
            return true;
        }
        return false;
    }

    public boolean isBranchCurrent(BranchHelper branch) {
        if (this.currentBranch == branch) {
            return true;
        }
        if (this.currentBranch == null) {
            return false;
        }
        try {
            BranchTrackingStatus status = BranchTrackingStatus.of((Repository)this.repoHelper.repo, (String)this.currentBranch.getRefName());
            if (branch instanceof RemoteBranchHelper && status != null) {
                Repository cfr_ignored_0 = this.repoHelper.repo;
                if (Repository.shortenRefName((String)status.getRemoteTrackingBranch()).equals(branch.getRefName())) {
                    return true;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Map<CommitHelper, List<BranchHelper>> getAllBranchHeads() {
        HashMap<CommitHelper, List<BranchHelper>> heads = new HashMap<CommitHelper, List<BranchHelper>>();
        this.refreshHeadIds();
        List<BranchHelper> branches = this.getAllBranches();
        for (BranchHelper branch : branches) {
            CommitHelper head = branch.getCommit();
            if (heads.containsKey(head)) {
                ((List)heads.get(head)).add(branch);
                continue;
            }
            heads.put(head, Stream.of(branch).collect(Collectors.toList()));
        }
        return heads;
    }

    public List<String> getBranchesWithHead(String commitId) {
        return this.getBranchesWithHead(this.repoHelper.getCommit(commitId));
    }

    public List<String> getBranchesWithHead(CommitHelper commit) {
        List<BranchHelper> branches = this.getAllBranchHeads().get(commit);
        List<String> branchLabels = new LinkedList<String>();
        if (branches != null) {
            branchLabels = branches.stream().map(RefHelper::getRefName).collect(Collectors.toList());
        }
        return branchLabels;
    }

    public List<String> getCurrentBranches() {
        ArrayList<String> branches = new ArrayList<String>();
        for (BranchHelper branch : this.getAllBranches()) {
            if (!this.isBranchCurrent(branch)) continue;
            branches.add(branch.getRefName());
        }
        return branches;
    }

    public List<String> getCurrentAbbrevBranches() {
        ArrayList<String> branches = new ArrayList<String>();
        for (BranchHelper branch : this.getAllBranches()) {
            if (!this.isBranchCurrent(branch)) continue;
            branches.add(branch.getAbbrevName());
        }
        return branches;
    }

    public static enum BranchType {
        LOCAL,
        REMOTE;

    }
}

