/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.CommitHelper;
import elegit.RefHelper;
import elegit.RepoHelper;
import java.io.IOException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.BranchTrackingStatus;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;

public abstract class BranchHelper
extends RefHelper {
    String refPathString;
    public RepoHelper repoHelper;

    public BranchHelper(String refPathString, RepoHelper repoHelper) {
        this.refPathString = refPathString;
        this.repoHelper = repoHelper;
        this.setHead(this.repoHelper.getCommit(refPathString));
        this.refName = this.parseBranchName();
    }

    protected abstract String parseBranchName();

    public abstract void checkoutBranch() throws GitAPIException, IOException;

    private void setHead(CommitHelper head) {
        this.commit = head;
    }

    public String toString() {
        return this.refName;
    }

    public String getRefPathString() {
        return this.refPathString;
    }

    public ObjectId getHeadId() throws IOException {
        if (this.commit != null) {
            return this.commit.getObjectId();
        }
        ObjectId headId = this.repoHelper.getRepo().resolve(this.refPathString);
        this.setHead(this.repoHelper.getCommit(headId));
        return headId;
    }

    public BranchTrackingStatus getStatus() throws IOException {
        return BranchTrackingStatus.of((Repository)this.repoHelper.repo, (String)this.refName);
    }
}

