/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import java.util.Collection;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseButton;
import javafx.scene.paint.Paint;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.VLineTo;

public class ArrowButtonSkin
extends Group
implements Skin<Button> {
    static final double ARROW_BASE_HEIGHT = 4.0;
    static final double ARROW_TIP_HEIGHT = 10.0;
    static final double ARROW_BASE_WIDTH_RATIO = 0.7;
    Button button;
    boolean up;
    boolean down;
    boolean left;
    boolean right;

    public ArrowButtonSkin(Button button) {
        this.button = button;
        this.setOnMouseClicked(event -> {
            if (event.getButton() == MouseButton.PRIMARY) {
                button.getOnAction().handle((Event)new ActionEvent((Object)button, event.getTarget()));
            }
        });
        this.button.textProperty().addListener((observable, oldValue, newValue) -> this.draw());
    }

    private void draw() {
        Label text = new Label(this.button.getText());
        text.getStyleClass().setAll((Collection)this.button.getStyleClass());
        text.setId(this.button.getId());
        Path path = new Path();
        text.backgroundProperty().addListener((observable, oldValue, newValue) -> {
            Paint color = Paint.valueOf((String)"#52B3D9");
            path.setFill(color);
            path.setStroke(color);
        });
        this.button.getStyleClass().clear();
        this.getChildren().setAll((Object[])new Node[]{path, text});
        Platform.runLater(() -> {
            PathElement[] curves;
            double labelWidth = text.getBoundsInLocal().getWidth();
            double labelHeight = text.getBoundsInLocal().getHeight();
            text.setTranslateX(this.button.getInsets().getLeft());
            text.setTranslateY(this.button.getInsets().getTop());
            MoveTo startPoint = new MoveTo();
            double width = labelWidth + this.button.getInsets().getLeft();
            double height = labelHeight + this.button.getInsets().getBottom() + this.button.getInsets().getTop();
            startPoint.setX(0.0);
            startPoint.setY(0.0);
            path.getElements().add((Object)startPoint);
            if (this.up) {
                curves = this.getArrowSide(width, height, ArrowDirection.UP);
                path.getElements().add((Object)curves[0]);
                path.getElements().add((Object)curves[1]);
            } else {
                HLineTo topLine = new HLineTo(width);
                path.getElements().add((Object)topLine);
            }
            if (this.right) {
                curves = this.getArrowSide(width, height, ArrowDirection.RIGHT);
                path.getElements().add((Object)curves[0]);
                path.getElements().add((Object)curves[1]);
            } else {
                VLineTo rightLine = new VLineTo(height);
                path.getElements().add((Object)rightLine);
            }
            if (this.down) {
                curves = this.getArrowSide(width, height, ArrowDirection.DOWN);
                path.getElements().add((Object)curves[0]);
                path.getElements().add((Object)curves[1]);
            } else {
                HLineTo bottomLine = new HLineTo(0.0);
                path.getElements().add((Object)bottomLine);
            }
            if (this.left) {
                curves = this.getArrowSide(width, height, ArrowDirection.LEFT);
                path.getElements().add((Object)curves[0]);
                path.getElements().add((Object)curves[1]);
            } else {
                VLineTo leftLine = new VLineTo(0.0);
                path.getElements().add((Object)leftLine);
            }
        });
    }

    private PathElement[] getArrowSideCubic(double width, double height, ArrowDirection direction, boolean isConcave) {
        CubicCurveTo[] curve = new CubicCurveTo[]{new CubicCurveTo(), new CubicCurveTo()};
        if (isConcave) {
            switch (direction) {
                case LEFT: {
                    double controlX = 0.0;
                    double controlY = height - 0.7 * height / 2.0;
                    double x = -10.0;
                    double y = height / 2.0;
                    curve[0].setX(x);
                    curve[0].setY(y);
                    curve[0].setControlX1(controlX);
                    curve[0].setControlY1(controlY);
                    curve[0].setControlX2(controlX - 4.0);
                    curve[0].setControlY2(controlY);
                    controlX = 0.0;
                    controlY = 0.7 * height / 2.0;
                    x = 0.0;
                    y = 0.0;
                    curve[1].setX(x);
                    curve[1].setY(y);
                    curve[1].setControlX1(controlX - 4.0);
                    curve[1].setControlY1(controlY);
                    curve[1].setControlX2(controlX);
                    curve[1].setControlY2(controlY);
                    break;
                }
                case RIGHT: {
                    double controlX = width;
                    double controlY = 0.7 * height / 2.0;
                    double x = width + 10.0;
                    double y = height / 2.0;
                    curve[0].setX(x);
                    curve[0].setY(y);
                    curve[0].setControlX1(controlX);
                    curve[0].setControlY1(controlY);
                    curve[0].setControlX2(controlX + 4.0);
                    curve[0].setControlY2(controlY);
                    controlX = width;
                    controlY = height - 0.7 * height / 2.0;
                    x = width;
                    y = height;
                    curve[1].setX(x);
                    curve[1].setY(y);
                    curve[1].setControlX1(controlX + 4.0);
                    curve[1].setControlY1(controlY);
                    curve[1].setControlX2(controlX);
                    curve[1].setControlY2(controlY);
                    break;
                }
                case UP: {
                    double controlX = 0.7 * width / 2.0;
                    double controlY = 0.0;
                    double x = width / 2.0;
                    double y = -10.0;
                    curve[0].setX(x);
                    curve[0].setY(y);
                    curve[0].setControlX1(controlX);
                    curve[0].setControlY1(controlY);
                    curve[0].setControlX2(controlX);
                    curve[0].setControlY2(controlY - 4.0);
                    controlX = width - 0.7 * width / 2.0;
                    controlY = 0.0;
                    x = width;
                    y = 0.0;
                    curve[1].setX(x);
                    curve[1].setY(y);
                    curve[1].setControlX1(controlX);
                    curve[1].setControlY1(controlY - 4.0);
                    curve[1].setControlX2(controlX);
                    curve[1].setControlY2(controlY);
                    break;
                }
                case DOWN: {
                    double controlX = width - 0.7 * width / 2.0;
                    double controlY = height;
                    double x = width / 2.0;
                    double y = height + 10.0;
                    curve[0].setX(x);
                    curve[0].setY(y);
                    curve[0].setControlX1(controlX);
                    curve[0].setControlY1(controlY);
                    curve[0].setControlX2(controlX);
                    curve[0].setControlY2(controlY + 4.0);
                    controlX = 0.7 * width / 2.0;
                    controlY = height;
                    x = 0.0;
                    y = height;
                    curve[1].setX(x);
                    curve[1].setY(y);
                    curve[1].setControlX1(controlX);
                    curve[1].setControlY1(controlY + 4.0);
                    curve[1].setControlX2(controlX);
                    curve[1].setControlY2(controlY);
                }
            }
        } else {
            switch (direction) {
                case LEFT: {
                    double controlX = -4.0;
                    double controlY = height;
                    double x = -10.0;
                    double y = height / 2.0;
                    curve[0].setX(x);
                    curve[0].setY(y);
                    curve[0].setControlX1(controlX);
                    curve[0].setControlY1(controlY);
                    curve[0].setControlX2(controlX);
                    curve[0].setControlY2(controlY - 0.7 * height / 2.0);
                    controlX = -4.0;
                    controlY = 0.0;
                    x = 0.0;
                    y = 0.0;
                    curve[1].setX(x);
                    curve[1].setY(y);
                    curve[1].setControlX1(controlX);
                    curve[1].setControlY1(controlY + 0.7 * height / 2.0);
                    curve[1].setControlX2(controlX);
                    curve[1].setControlY2(controlY);
                    break;
                }
                case RIGHT: {
                    double controlX = width + 4.0;
                    double controlY = 0.0;
                    double x = width + 10.0;
                    double y = height / 2.0;
                    curve[0].setX(x);
                    curve[0].setY(y);
                    curve[0].setControlX1(controlX);
                    curve[0].setControlY1(controlY);
                    curve[0].setControlX2(controlX);
                    curve[0].setControlY2(controlY + 0.7 * height / 2.0);
                    controlX = width + 4.0;
                    controlY = height;
                    x = width;
                    y = height;
                    curve[1].setX(x);
                    curve[1].setY(y);
                    curve[1].setControlX1(controlX);
                    curve[1].setControlY1(controlY - 0.7 * height / 2.0);
                    curve[1].setControlX2(controlX);
                    curve[1].setControlY2(controlY);
                    break;
                }
                case UP: {
                    double controlX = 0.0;
                    double controlY = -4.0;
                    double x = width / 2.0;
                    double y = -10.0;
                    curve[0].setX(x);
                    curve[0].setY(y);
                    curve[0].setControlX1(controlX);
                    curve[0].setControlY1(controlY);
                    curve[0].setControlX2(controlX + 0.7 * width / 2.0);
                    curve[0].setControlY2(controlY);
                    controlX = width;
                    controlY = -4.0;
                    x = width;
                    y = 0.0;
                    curve[1].setX(x);
                    curve[1].setY(y);
                    curve[1].setControlX1(controlX - 0.7 * width / 2.0);
                    curve[1].setControlY1(controlY);
                    curve[1].setControlX2(controlX);
                    curve[1].setControlY2(controlY);
                    break;
                }
                case DOWN: {
                    double controlX = width;
                    double controlY = height + 4.0;
                    double x = width / 2.0;
                    double y = height + 10.0;
                    curve[0].setX(x);
                    curve[0].setY(y);
                    curve[0].setControlX1(controlX);
                    curve[0].setControlY1(controlY);
                    curve[0].setControlX2(controlX - 0.7 * width / 2.0);
                    curve[0].setControlY2(controlY);
                    controlX = 0.0;
                    controlY = height + 4.0;
                    x = 0.0;
                    y = height;
                    curve[1].setX(x);
                    curve[1].setY(y);
                    curve[1].setControlX1(controlX + 0.7 * width / 2.0);
                    curve[1].setControlY1(controlY);
                    curve[1].setControlX2(controlX);
                    curve[1].setControlY2(controlY);
                }
            }
        }
        return curve;
    }

    private PathElement[] getArrowSide(double width, double height, ArrowDirection direction) {
        LineTo[] lines = new LineTo[]{new LineTo(), new LineTo()};
        switch (direction) {
            case LEFT: {
                lines[0].setX(-10.0);
                lines[0].setY(height / 2.0);
                lines[1].setX(0.0);
                lines[1].setY(0.0);
                break;
            }
            case RIGHT: {
                lines[0].setX(width + 10.0);
                lines[0].setY(height / 2.0);
                lines[1].setX(width);
                lines[1].setY(height);
                break;
            }
            case UP: {
                lines[0].setX(width / 2.0);
                lines[0].setY(-10.0);
                lines[1].setX(width);
                lines[1].setY(0.0);
                break;
            }
            case DOWN: {
                lines[0].setX(width / 2.0);
                lines[0].setY(height + 10.0);
                lines[1].setX(0.0);
                lines[1].setY(height);
            }
        }
        return lines;
    }

    public Button getSkinnable() {
        return this.button;
    }

    public Node getNode() {
        return this;
    }

    public void dispose() {
    }

    private static enum ArrowDirection {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

